CREATE TABLE ais.QuerySyncData (
  QuerySyncData_Id BIGINT IDENTITY,
  GID UNIQUEIDENTIFIER NOT NULL,
  DatBeg DATE NOT NULL,
  QDatBeg BIGINT NOT NULL,
  DatEnd DATE NOT NULL,
  QDatEnd BIGINT NOT NULL,
  TimeMark DATETIME NOT NULL,
  QTimeMark BIGINT NOT NULL,
  MaxTimeLife INT NULL,
  RecordCount INT NOT NULL,
  dt_ins DATETIME NULL DEFAULT (GETDATE()),
  user_ins VARCHAR(50) NULL DEFAULT (SUSER_SNAME()),
  CONSTRAINT PK_QuerySyncData_QuerySyncData_Id PRIMARY KEY CLUSTERED (QuerySyncData_Id) WITH (FILLFACTOR = 80)
) ON [PRIMARY]
GO

EXEC sys.sp_addextendedproperty N'MS_Description',
                                'Идентификатор запроса',
                                'SCHEMA',
                                N'ais',
                                'TABLE',
                                N'QuerySyncData',
                                'COLUMN',
                                N'GID'
GO

EXEC sys.sp_addextendedproperty N'MS_Description',
                                'Дата начала',
                                'SCHEMA',
                                N'ais',
                                'TABLE',
                                N'QuerySyncData',
                                'COLUMN',
                                N'DatBeg'
GO

EXEC sys.sp_addextendedproperty N'MS_Description',
                                'Дата конца',
                                'SCHEMA',
                                N'ais',
                                'TABLE',
                                N'QuerySyncData',
                                'COLUMN',
                                N'DatEnd'
GO

EXEC sys.sp_addextendedproperty N'MS_Description',
                                'Запрашиваемое кол-во',
                                'SCHEMA',
                                N'ais',
                                'TABLE',
                                N'QuerySyncData',
                                'COLUMN',
                                N'RecordCount'
GO